function meta(files, fun)
%meta(files, fun)

%Copyright 2008, 2010 Anton Blad
%
%This file is part of firgen.
%
%firgen is free software: you can redistribute it and/or modify
%it under the terms of the GNU General Public License as published by
%the Free Software Foundation, either version 3 of the License, or
%(at your option) any later version.
%
%firgen is distributed in the hope that it will be useful,
%but WITHOUT ANY WARRANTY; without even the implied warranty of
%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%GNU General Public License for more details.
%
%You should have received a copy of the GNU General Public License
%along with firgen.  If not, see <http://www.gnu.org/licenses/>

fn = strcat(fun, '.m');
fid = fopen(fn, 'w+');

numfiles = length(files);

fprintf(fid, 'function %s(dir)\n', fun);
fprintf(fid, '%%Automatically generated by meta from source files:\n');
for f = 1:numfiles
	fprintf(fid, '%%%s\n', files{f});
end
fprintf(fid, '\n');

for f = 1:numfiles
	srcfn = files{f};
	genfn = regexprep(srcfn, '.*/', '');
	genfid = fopen(srcfn, 'r');
	
	fprintf(fid, 'fn = strcat(dir, ''/'', ''%s'');\n', genfn);
	fprintf(fid, 'fid = fopen(fn, ''w+'');\n');

	while ~feof(genfid)
		line = fgetl(genfid);
		line = sprintf('fprintf(fid, ''%s\\\\n'');\n', strrep(line, '''', ''''''));
		fprintf(fid, line);
	end
	
	fprintf(fid, 'fclose(fid);\n');
	fprintf(fid, '\n');

	fclose(genfid);
end

fclose(fid);

